//
//  WDInstallerController.h
//
//  Created by Clark Jackson on 2/1/08.
//  Copyright 2008 Western Digital. All rights reserved.
//

//#include <Security/Security.h>


typedef enum WDDaemonType
{
    kWDSmartWareServer = 0,
    kMemeod = 1, 
    kWDDM = 2,
}
WDDaemonType;


@interface WDInstallerController : NSObject
{
	BOOL                fInstall,
                        fLicenseHasBeenAccepted,
                        fOSAuthorizationIsCancelled;

	int                 fInstallIndex;

	AuthorizationRef    fAuthorizationRef;

	NSString            *fCopyToolPath,
                        *fResourcesInstallDestinationDirPath,
                        *fComponentToDelete;

	NSArray             *fBillOfWDMaterialsRemovePaths,
                        *fBillOfMemeoMaterialsRemovePaths,
                        *fLaunchCtlParameters;

	NSMutableArray      *fBillOfMaterialsInstallFromPaths,
                        *fBillOfMaterialsInstallToPaths;
}

#pragma mark ------- Initialization and Setup ------- 
- (void) copyResourcesToHomeDirectory;
- (void) unzipFilesInPath:(NSString *)dirPath;

#pragma mark ------- Authorization & NSTask Methods ------- 
- (void) activate;
- (OSStatus) preauthorizeForRight;
- (NSData *) authorizationAsData;
- (NSTask *) taskForExecutable:(NSString *)execPath arguments:(NSArray *)args;
- (void) launchTask:(int)typeOfLaunch;
- (void) launchSelfContainedNSTask;

#pragma mark ------- Inventory ------- 
- (NSMutableArray *) installedKEXTs;
- (NSMutableArray *) missingComponents;

#pragma mark loading/unloading daemons (Apple method)
- (void)handleLoadingOfDaemon:(WDDaemonType)deamonIndex to:(BOOL)startStop;
- (OSStatus)launchToolForDaemon:(WDDaemonType)daemonIndex to:(BOOL)startStop withAuthorization:(AuthorizationRef)auth;
//#pragma mark ------- Apple Installer Methods -------
//#pragma mark loading/unloading WDDM
//- (void)handleRestartWDDM:(BOOL)startStop;
//- (OSStatus)startWDDM:(BOOL)startStop authorization:(AuthorizationRef)auth;
//#pragma mark ------- loading/unloading WDSmartwareServer -------
//- (void)handleRestartWDSmartWareServer:(BOOL)startStop;
//- (OSStatus)startWDSmartWareServer:(BOOL)startStop authorization:(AuthorizationRef)auth;
//#pragma mark ------- loading/unloading Memeod -------
//- (void)handleRestartMemeod:(BOOL)startStop;
//- (OSStatus)startMemeod:(BOOL)startStop authorization:(AuthorizationRef)auth;

#pragma mark ------- Accesors -------
- (BOOL) fOSAuthorizationIsCancelled;
- (void) setFOSAuthorizationIsCancelled:(BOOL)cancelState;
- (void) setFInstallIndex:(int) theIndex;
- (NSMutableArray *)fBillOfMaterialsInstallFromPaths;
- (NSArray *)fBillOfWDMaterialsRemovePaths;
- (NSArray *)fBillOfMemeoMaterialsRemovePaths;
- (NSArray *)fLaunchCtlParameters;
- (void)setFLaunchCtlParameters:(NSArray*)parameters;
- (void) setFComponentToDelete:(NSString *)theComponent;

@end
